<?php
require_once 'header.php';

if(!$usersObject->ID()) {
	header("Location: /");
	exit;
}

$the_domain = 'http://'.$_SERVER['SERVER_NAME'];

if(isset($_GET['del'])) {
	$id = $db->escape(abs(intval($_GET['del'])));
	$db->query(sprintf("DELETE FROM advertisers WHERE advID = '%d' AND user = '%d'", $id, $usersObject->ID()));
	if($db->rows_affected) {
		print '<div class="alert alert-error">Campaign removed</div>';
	}
}

?>
<div class="container ctwhite">
	<?php require_once 'announcements.php';?> 
</div>
	
<div class="container ctwhite" style="margin-top:20px;">

	<h3 class="headline-inline"><?=translate('your_cmp')?> (<a href="/new-campaign.php"><?=translate('create_cmp')?></a>)</h3>
	
	<?php
	if(isset($_GET['edit'])) {
		$id = $db->escape(abs(intval($_GET['edit'])));
		$c = $db->get_row(sprintf("SELECT title, site FROM advertisers WHERE advID = '%d' AND user = '%d'", $id, $usersObject->ID()));
		if(!$c) die("Campaign not found");
		
		if(isset($_POST['sb'])) {
		$title = (string) $db->escape(trim(strip_tags($_POST['title'])));
		$site = (string) $db->escape(trim(strip_tags($_POST['site'])));
		
		if(empty($title) OR !stristr($site, 'http')) {
			print '<div class="alert alert-warning">Please enter site title and a domain name starting with http:// or https://</div>';
		}else{
			//update it
			$db->query(sprintf("UPDATE advertisers SET site = '$site', title = '$title' WHERE advID = '%d' AND user = '%d'", $id, $usersObject->ID()));
			
			if($db->rows_affected) {
				print '<div class="alert alert-warning">Updated campaign. <a href="advertiser.php">Close this</a></div>';
			}
			
			$c = $db->get_row(sprintf("SELECT title, site FROM advertisers WHERE advID = '%d' AND user = '%d'", $id, $usersObject->ID()));	
		}
		}//form
	?>	
		<form method="POST" action="" class="form-horizontal">
		<label><?=translate('cmp_title') ?>:</label>
		<input type="text" name="title" value="<?php print $c->title; ?>" class="input-xxlarge"/>
		<br/>
		<label><?=translate('site_url') ?>:</label>
		<input type="text" name="site" value="<?php print $c->site; ?>" class="input-xxlarge"/>
		<br/><br/>
		<input type="submit" name="sb" value="<?=translate('update_btn') ?>" class="btn btn-warning btn-medium"/>
		</form>
	<?php		
	}
	?>
	
	<?php
	$user_links = $db->get_results(
					sprintf("SELECT * FROM advertisers WHERE user = '%d' ORDER BY advID DESC", $db->escape($usersObject->ID())));
	?>
	
	<table class="table table-striped table-bordered table-hover">
		<thead>
			<th><?=translate('title') ?></th>
			<th><?=translate('website_address') ?></th>
			<th><?=translate('country') ?></th>
			<th><?=translate('ordered') ?></th>
			<th><?=translate('sent') ?></th>
			<th><?=translate('remaining') ?></th>
			<th><?=translate('status') ?></th>
			<th>&nbsp;</th>
		</thead>
		<tbody>
			<?php
			if(count($user_links)) {
				foreach($user_links as $c) {
					printf('<tr data-ID="%d" class="last-item">', $c->advID);
					printf('<td>%s</td>', $c->title);
					printf('<td><a href="%s" target="_blank">%s</a><br/>', $c->site, $c->site);
					printf('<td>%s</td>', $c->country);
					printf('<td>%d</td>', $c->ordered);
					printf('<td>%d</td>', $c->sent);
					printf('<td>%d</td>', $c->ordered-$c->sent);
					printf('<td>%s</td>', $c->status);
					print '<td>
							<a href="advertiser.php?edit='.$c->advID.'"><b class="icon-edit"></b></a>
							<a href="advertiser.php?del='.$c->advID.'" class="confirm"><b class="icon-remove"></b></a>
						   </td>';
					print '</tr>';
				}	
			}
			?>
		</tbody>
	</table>
		
</div>

<?php
require_once 'footer.php';
?>